/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import no.statkart.launcher.client.Feil;

class Parametre {
    private String tjener;
    private String brukernavn;
    private char[] passord;
    private String heap;
    private long oppdatert;

    Parametre() {
    }

    Parametre(Properties properties) {
        this.medTjener(properties.getProperty("tjener"));
        this.medBrukernavn(properties.getProperty("brukernavn"));
        this.medHeap(properties.getProperty("heap"));
        this.oppdatert = Long.parseLong(properties.getProperty("oppdatert"));
    }

    Properties tilProperties() {
        Properties p = new Properties();
        if (this.tjener != null) {
            p.setProperty("tjener", this.tjener);
        }
        if (this.brukernavn != null) {
            p.setProperty("brukernavn", this.brukernavn);
        }
        if (this.heap != null) {
            p.setProperty("heap", this.heap);
        }
        p.setProperty("oppdatert", Long.toString(this.oppdatert));
        return p;
    }

    Parametre medTjener(String tjener) {
        this.tjener = tjener;
        this.setOppdatert();
        return this;
    }

    Parametre medBrukernavn(String brukernavn) {
        this.brukernavn = brukernavn;
        this.setOppdatert();
        return this;
    }

    Parametre medPassord(char[] passord) {
        this.passord = passord == null ? null : Arrays.copyOf(passord, passord.length);
        this.setOppdatert();
        return this;
    }

    Parametre medHeap(String heap) {
        this.heap = heap;
        this.setOppdatert();
        return this;
    }

    String getTjener() {
        return this.tjener;
    }

    String getBrukernavn() {
        return this.brukernavn;
    }

    char[] getPassord() {
        return this.passord;
    }

    String getHeap() {
        return this.heap;
    }

    long getOppdatert() {
        return this.oppdatert;
    }

    private void setOppdatert() {
        this.oppdatert = System.currentTimeMillis();
    }

    void kontroller() throws Exception {
        this.kontrollerHeap();
        this.kontrollerTjener();
    }

    void kontrollerHeap() {
        Integer.parseInt(this.heap);
    }

    void kontrollerTjener() throws Exception {
        new URL(this.tjener);
    }

    public String toString() {
        return this.tilProperties().toString();
    }

    public Feil tilFeil() {
        try {
            this.kontroller();
            return null;
        }
        catch (Exception e) {
            return new Feil(e, this);
        }
    }
}

