/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import no.statkart.launcher.client.Feil;
import no.statkart.launcher.client.Konfigurasjonsverdi;
import no.statkart.launcher.client.Parametre;
import no.statkart.launcher.client.StandardOppsett;

public class TjenerKontroll {
    private final StandardOppsett standard;

    TjenerKontroll(StandardOppsett standard) {
        this.standard = standard;
    }

    Optional<Feil> utenBrukerPassord(Parametre param) {
        try {
            URL url = this.tilGetDownUrl(param.getTjener());
            this.check(url);
            return Optional.empty();
        }
        catch (IOException e) {
            Feil feil = new Feil(e, param);
            if (feil.erBrukerPassordFeil()) {
                feil = new Feil(e, param, false);
            }
            return Optional.of(feil);
        }
    }

    Optional<Feil> medBrukerPassord(Parametre param) {
        try {
            param.kontroller();
            URL url = this.tilGetDownUrl(param.getTjener());
            this.check(url, param.getBrukernavn(), param.getPassord());
            this.registrerInnlogging(param);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(new Feil(e, param));
        }
    }

    boolean klientAkseptert(Parametre param) {
        try {
            URL url = this.tilKlientValideringUrl(param.getTjener(), this.finnKlientVersjon());
            this.check(url);
            return true;
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private URL tilGetDownUrl(String baseUrl) throws IOException {
        String contextPath = this.standard.getContextPath();
        return new URL(baseUrl + contextPath + "/vault/getdown.txt");
    }

    private URL tilKlientValideringUrl(String baseUrl, String klientVersjon) throws IOException {
        String contextPath = this.standard.getContextPath();
        String query = String.format("version=%s", URLEncoder.encode(klientVersjon, StandardCharsets.UTF_8));
        return new URL(baseUrl + contextPath + "/validate?" + query);
    }

    private String finnKlientVersjon() {
        return this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.VERSION);
    }

    private void registrerInnlogging(final Parametre param) {
        this.loggInnIKlienten(param);
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(param.getBrukernavn(), param.getPassord());
            }
        });
    }

    private void loggInnIKlienten(Parametre param) {
        System.setProperty("app.skif.server_username", param.getBrukernavn());
        System.setProperty("app.skif.server_password", String.copyValueOf(param.getPassord()));
    }

    private void check(URL url) throws IOException {
        this.check(url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(URL url, String brukernavn, char[] passord) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            if (brukernavn != null && passord != null) {
                conn.setRequestProperty("Authorization", "Basic " + TjenerKontroll.encode(brukernavn, passord));
            }
            conn.getInputStream();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static String encode(String user, char[] pass) {
        String p = pass == null ? "" : String.copyValueOf(pass);
        return Base64.getEncoder().encodeToString((user + ":" + p).getBytes());
    }
}

