/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.statkart.launcher.client.Konfigurasjon;
import no.statkart.launcher.client.Konfigurasjonsverdi;
import no.statkart.launcher.client.Parametre;
import no.statkart.launcher.client.Work;

class StandardOppsett {
    private static final Pattern CONTEXT_PATH = Pattern.compile("[a-z]+://[^/]+(/.*)?/vault/?$");
    private final Path rot;
    private Konfigurasjon konfigurasjon;
    private Parametre parametre;
    private String contextPath;
    private Work work;

    StandardOppsett(Path rot) {
        this.rot = rot;
    }

    Path getRot() {
        return this.rot;
    }

    Konfigurasjon getKonfigurasjon() {
        if (this.konfigurasjon == null) {
            this.konfigurasjon = new Konfigurasjon(this.rot);
        }
        return this.konfigurasjon;
    }

    Parametre getParametre() {
        if (this.parametre == null) {
            this.parametre = new Parametre().medTjener(this.getKonfigurasjon().get(Konfigurasjonsverdi.DEFAULT_SERVER)).medHeap(this.getKonfigurasjon().get(Konfigurasjonsverdi.DEFAULT_HEAP));
        }
        return this.parametre;
    }

    String getContextPath() throws IOException {
        if (this.contextPath == null) {
            Path getdownTxt = this.rot.resolve("getdown.txt");
            Properties properties = new Properties();
            try (InputStream is = Files.newInputStream(getdownTxt, new OpenOption[0]);){
                properties.load(is);
            }
            String appbase = properties.getProperty("appbase");
            Matcher m = CONTEXT_PATH.matcher(appbase);
            if (!m.matches()) {
                throw new RuntimeException("Feilkonfigurert appbase i getdown.txt");
            }
            this.contextPath = m.group(1);
            if (this.contextPath == null) {
                this.contextPath = "";
            }
        }
        return this.contextPath;
    }

    Work getWork() throws IOException {
        if (this.work == null) {
            this.work = new Work(this, this.currentSystem().finnMappeMedSkriverettigheter());
        }
        return this.work;
    }

    private OS currentSystem() {
        String name = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (name.contains("nux")) {
            return new Linux();
        }
        if (name.contains("mac")) {
            return new Mac();
        }
        return new Windows();
    }

    private class Mac
    implements OS {
        private Mac() {
        }

        @Override
        public Path finnMappeMedSkriverettigheter() {
            String home = System.getProperty("user.home");
            if (home == null) {
                throw new IllegalStateException("Fant ikke variablen user.home");
            }
            String rot = StandardOppsett.this.getKonfigurasjon().get(Konfigurasjonsverdi.WORK_OSX).replace("%HOME%", home);
            return Paths.get(rot, new String[0]);
        }
    }

    private class Linux
    implements OS {
        private Linux() {
        }

        @Override
        public Path finnMappeMedSkriverettigheter() {
            String home = System.getProperty("user.home");
            if (home == null) {
                throw new IllegalStateException("Fant ikke variablen user.home");
            }
            String rot = StandardOppsett.this.getKonfigurasjon().get(Konfigurasjonsverdi.WORK_LINUX).replace("%HOME%", home);
            return Paths.get(rot, new String[0]);
        }
    }

    private class Windows
    implements OS {
        private Windows() {
        }

        @Override
        public Path finnMappeMedSkriverettigheter() {
            String appdata = System.getenv("APPDATA");
            if (appdata == null) {
                throw new IllegalStateException("Fant ikke variablen APPDATA");
            }
            String rot = StandardOppsett.this.getKonfigurasjon().get(Konfigurasjonsverdi.WORK_WINDOWS).replace("%HOME%", appdata);
            return Paths.get(rot, new String[0]);
        }
    }

    private static interface OS {
        public Path finnMappeMedSkriverettigheter() throws IOException;
    }
}

